/*
** bricker.c for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 12:44:37 2006 jean-marc le-roux
** Last update Sun Nov 19 19:49:48 2006 Spycam
*/

#include "game.h"
#include "bricker.h"

s_game	*g_game;

void		bricker_create(s_vector3s		poss,
			       float			ray_int,
			       float			ray_ext)
{
  s_bricker	*bricker;
  s_vector3	vector3;
  s_vector3	color;

  vector3.x = sphere2cart(poss).x;
  vector3.y = sphere2cart(poss).y;
  vector3.z = sphere2cart(poss).z;
  color.x = 0.5f + (rand() % 1000) / 1000.0f;
  color.y = 0.5f + (rand() % 1000) / 1000.0f;
  color.z = 0.5f + (rand() % 1000) / 1000.0f;
  bricker = malloc(sizeof (s_bricker));
  if (bricker != NULL)
    {
      bricker->pos = vector3;
      bricker->poss = poss;
      bricker->pos.y += 20 + rand() % 10;
      bricker->ray_ext = ray_ext;
      bricker->ray_int = ray_int;
      bricker->next = g_game->map->bricker;
      bricker->speed = 0.015;
      bricker->boost = 0.010;
      bricker->color = color;
      bricker->isdead = 0;
      bricker->ismother = 0;
    }
  g_game->map->bricker = bricker;
}

void		bricker_mother_create(s_vector3s	poss)
{
  s_bricker	*bricker;
  s_vector3	vector3;
  s_vector3	color;

  vector3.x = sphere2cart(poss).x;
  vector3.y = sphere2cart(poss).y;
  vector3.z = sphere2cart(poss).z;
  color.x = 1.0;
  color.y = 0.0;
  color.z = 0.0;
  bricker = malloc(sizeof (s_bricker));
  if (bricker != NULL)
    {
      bricker->pos = vector3;
      bricker->poss = poss;
      /*      bricker->pos.y -= 1;*/
      bricker->ray_ext = 4;
      bricker->ray_int = 1;
      bricker->next = g_game->map->bricker;
      bricker->speed = 0.015;
      bricker->boost = 0.010;
      bricker->color = color;
      bricker->isdead = 0;
      bricker->ismother = 1;
    }
  g_game->map->bricker = bricker;
}


void	bricker_destroy()
{
}

void	bricker_update()
{
  s_bricker     *pos;
  s_bricker     *prev;
  s_bricker	*next;
  s_roller	*roll;
  s_vector3	vitpos;
  s_vector3s	vitposs;

  prev = NULL;
  pos = g_game->map->bricker;
  while (pos)
  {
    next = pos->next;
    if (pos->isdead || pos->pos.y > pos->ray_ext || \
	pos->poss.rayon > g_game->players[0]->poss.rayon + 2)
      pos->pos.y -= pos->speed * (SDL_GetTicks() - g_game->to);
    else
    {
      roll = g_game->map->roller;
      while (roll)
      {
	if ((abs(pos->pos.x - roll->pos.x) < pos->ray_ext + roll->rayon) &&
	    (abs(pos->pos.z - roll->pos.z) < pos->ray_ext + roll->rayon))
	{
	  if (!pos->ismother || (pos->ismother && g_game->map->bricker == pos \
				 && !pos->next))
	  {
	    g_game->map->nbbricker--;
	    pos->isdead = 1;
	    g_game->score += 20;
	  }
	  if (g_game->players[0]->transverser == -1)
	  {
	    vitposs = pos->poss;
	    vitpos = sphere2cart(vitposs);
	    roll->vit.x = roll->pos.x - vitpos.x;
	    roll->vit.z = roll->pos.z - vitpos.z;
	    /*      printf("Vect avant vit x:%f , z:%f\n", pos->vit.x, pos->vit.z);*/
	    roll->vit = normalize(roll->vit);
	  }
	  else
	    if (SDL_GetTicks() - g_game->players[0]->transverser > 5000)
	      g_game->players[0]->transverser = -1;
	}
	roll = roll->next;
      }
    }
    if (pos->pos.y < -30)
    {
      if (!prev)
        g_game->map->bricker = pos->next;
      else
        prev->next = pos->next;
      free(pos);
    }
    else
      prev = pos;
    pos = next;
  }

}

void	bricker_display()
{
  s_bricker	*bricker;

  for (bricker = g_game->map->bricker;
       bricker;
       bricker = bricker->next)
    {
      glPushMatrix();
      glTranslatef(bricker->pos.x, bricker->pos.y, bricker->pos.z);
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE);
      glDisable(GL_DEPTH_TEST);
      glColor4f(1.0f, 1.0f, 1.0f, 0.3f);
      glutSolidSphere(bricker->ray_ext, 10, 4);
      glColor4f(bricker->color.x,
		bricker->color.y,
		bricker->color.z,
		0.5f);
      glutSolidSphere(bricker->ray_int, 10, 4);
      glEnable(GL_DEPTH_TEST);
      glDisable(GL_BLEND);
      glPopMatrix();
      glColor3f(1.0f, 1.0f, 1.0f);
    }
}
