/*
** camera.c for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 04:28:32 2006 jean-marc le-roux
** Last update Sat Nov 18 19:17:07 2006 jean-marc le-roux
*/

#include "camera.h"
#include "game.h"

s_game		*g_game;

int		camera_init()
{
  g_game->camera = malloc(sizeof (s_camera));
  return (g_game->camera == NULL);
}

void		camera_create()
{
  if (camera_init())
    printf("Error during camera_init in camera.c\n");
  gluLookAt(5, 5, -5,
	    0, 0, 0,
	    0, 1, 0);
}

void		camera_destroy();

void		camera_update()
{
  s_vector3s	poss;
  s_vector3	pos;

  poss = g_game->players[0]->poss;
  poss.rayon += 25;
  pos = sphere2cart(poss);
  g_game->camera->position = pos;
  gluLookAt(pos.x, pos.y + 18, pos.z,
	    0, 0, 0,
	    0, 1, 0);
}

