/*
** game.h for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 00:13:11 2006 jean-marc le-roux
** Last update Sun Nov 19 19:21:42 2006 Spycam
*/

#ifndef GAME_H_
# define GAME_H_

# include <math.h>
# include <unistd.h>
# include <stdlib.h>
# include "menu.h"
# include "camera.h"
# include "graphic.h"
# include "physics.h"
# include "map.h"
# include "player.h"
# include "input.h"

# define NB_MAX_PLAYERS (2)
# define NB_TOUCHES (2)

struct game
{
  s_player		*players[NB_MAX_PLAYERS];
  s_map			*map;
  s_graphic		*graphic;
  s_camera		*camera;
  SDL_Event		event;
  s_menu		*menu;
  int			score;
  unsigned int		to;
  int			inputs[NB_TOUCHES];
};
typedef struct game	s_game;

extern s_game		*g_game;

void			game_create();

void			game_destroy();

void			game_update();

#endif /* GAME_H_ */
