/*
** graphic.c for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 00:32:18 2006 jean-marc le-roux
** Last update Mon Nov 20 14:18:21 2006 Spycam
*/

#include "game.h"
#include "graphic.h"

s_game	*g_game;

static void	graphic_init_opengl()
{
  float		ratio;

  ratio = WINDOW_WIDTH;
  ratio /= WINDOW_HEIGHT;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45.0f, ratio, 1.0f, 100.0f);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glShadeModel(GL_SMOOTH);
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
  glClearDepth(1.0f);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
}


static void	graphic_init()
{
  graphic_init_opengl();
  camera_create();
}

void	graphic_create(int	fullscreen)

{
  int		SetVideoModeFlag = 0;

  SetVideoModeFlag = (fullscreen) ? SDL_OPENGL | SDL_FULLSCREEN : SDL_OPENGL;
  g_game->graphic = malloc(sizeof (s_graphic));
  if (g_game->graphic != NULL)
  {
    if (SDL_Init(SDL_INIT_VIDEO) == -1)
    {
      printf("SDL_Init: %s\n", SDL_GetError());
    }
    SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    g_game->graphic->screen = SDL_SetVideoMode(WINDOW_WIDTH,
					       WINDOW_HEIGHT,
					       32,
					       SetVideoModeFlag | SDL_GL_DOUBLEBUFFER);
    if ((g_game->graphic->screen == NULL))
    {
      printf("SDL_SetVideoMode: %s\n", SDL_GetError());
      SDL_Quit();
    }
    atexit(SDL_Quit);
    SDL_WM_SetCaption("Arkanoid by Spycam & Prom'", "");
    if ((g_game->graphic = malloc(sizeof (s_graphic))))
      {
	graphic_init();
      }
  }
}

void	graphic_destroy()
{
}

void	graphic_update()
{

}

static void	graphic_prepare_display()
{
  float		LightAmbient[] = { 0.1f, 0.1f, 0.1f, 0.1f };
  float		LightDiffuse[] = { 0.5f, 0.5f, 0.5f, 1.0f };
  float		LightPosition[] = {0.0f, 10.0f, 0.0f, 1.0f};

  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHTING);
  glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
  glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
  glEnable(GL_LIGHT1);
  glClearColor(0, 0, 0, 0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glClearDepth(1.0f);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);
  glLoadIdentity();
  camera_update();
}

void		graphic_display()
{
  graphic_prepare_display();
  /*glBegin(GL_LINES);
  glColor3f(1.0f, 0.0f, 0.0f);
  glVertex3f(0.0f, 0.0f, 0.0f); glVertex3f(10.0f, 0.0f, 0.0f);
  glColor3f(0.0f, 1.0f, 0.0f);
  glVertex3f(0.0f, 0.0f, 0.0f); glVertex3f(0.0f, 10.0f, 0.0f);
  glColor3f(0.0f, 0.0f, 1.0f);
  glVertex3f(0.0f, 0.0f, 0.0f); glVertex3f(0.0f, 0.0f, 10.0f);
  glEnd();*/

  map_display();
  player_display(0);
  text_display(0, 23, 0, GLUT_BITMAP_HELVETICA_18, g_game->map->nbbricker);
      text_display(0, 25, 0, GLUT_BITMAP_HELVETICA_18, g_game->score);

  glFlush();
  SDL_GL_SwapBuffers();
}
