/*
** input.c for arkanoid in /u/ispe/raud_c/Piscine/rush/rush/raud_c-arkanoid/src
**
** Made by Spycam
** Login   <raud_c@epita.fr>
**
** Started on  Sat Nov 18 01:09:54 2006 Spycam
** Last update Mon Nov 20 14:15:44 2006 Spycam
*/

#include "input.h"

s_game	*g_game;

void	input_create()
{
  SDL_EnableKeyRepeat(20, 20);
  g_game->inputs[0] = 0;
  g_game->inputs[1] = 0;
}

void		input_update()
{
  SDL_Event	event;

  event = g_game->event;
  while (SDL_PollEvent(&event))
    {
      switch (event.type)
	{
	  case SDL_MOUSEMOTION :
	    /* Code for mouse move */
	    break;
	  case SDL_MOUSEBUTTONDOWN :
	    if ( event.button.button == SDL_BUTTON_RIGHT )
	      /* code when button right pressed */
	      if ( event.button.button == SDL_BUTTON_LEFT )
		/* code when button left pressed */
		break;
	  case SDL_KEYDOWN :
	    switch ( event.key.keysym.sym )
	      {
		case SDLK_LEFT :
		  if (g_game->players[0]->invert == -1)
		    g_game->inputs[1] = 1;
		  else
		    g_game->inputs[0] = 1;
		  break;
		case SDLK_RIGHT :
		  if (g_game->players[0]->invert == -1)
		    g_game->inputs[0] = 1;
		  else
		    g_game->inputs[1] = 1;
		  break;
		case SDLK_UP :
		  bonus_bigger();
		  break;
		case SDLK_DOWN :
		  bonus_smaller();
		  break;
		case SDLK_ESCAPE :
		  SDL_Quit();
		  exit(0);
		  break;
		case SDLK_d:
		  bonus_split();
		  break;
		case SDLK_f:
		  bonus_transverser();
		  break;
		case SDLK_g:
		  bonus_speed();
		  break;
		case SDLK_h:
		  bonus_inverser();
		  break;
		default :
		  break;
	      }
	    break;
	  case SDL_KEYUP :
	    switch (event.key.keysym.sym)
	      {
		case SDLK_LEFT :
		  if (g_game->players[0]->invert == -1)
		    g_game->inputs[1] = 0;
		  else
		    g_game->inputs[0] = 0;
		  break;
		case SDLK_RIGHT :
		  if (g_game->players[0]->invert == -1)
		    g_game->inputs[0] = 0;
		  else
		    g_game->inputs[1] = 0;
		  break;
		default :
		  break;
	      }
	    break;
	  case SDL_QUIT :
	    SDL_Quit();
	    exit(0);
	    break;
	}
    }

}

void	input_destroy();
