/*
** menu.c for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 20:13:58 2006 jean-marc le-roux
** Last update Sun Nov 19 18:36:50 2006 Spycam
*/

#include "game.h"
#include "menu.h"

s_game	*g_game;

void	menu_init(int	fullscreen)
{
  int	SetVideoModeFlag;

  SetVideoModeFlag = (fullscreen) ? SDL_OPENGL | SDL_FULLSCREEN : SDL_OPENGL;
  g_game->menu = malloc(sizeof (s_graphic));
  if (g_game->menu != NULL)
  {
    if (SDL_Init(SDL_INIT_VIDEO) == -1)
    {
      printf("SDL_Init: %s\n", SDL_GetError());
    }
    SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    g_game->menu->screen = SDL_SetVideoMode(WINDOW_WIDTH,
					    WINDOW_HEIGHT,
					    16,
					    SDL_SWSURFACE);
    if ((g_game->menu->screen == NULL))
    {
      printf("SDL_SetVideoMode: %s\n", SDL_GetError());
      SDL_Quit();
    }
    atexit(SDL_Quit);
    SDL_WM_SetCaption("Arkanoid by Spycam & Prom'", "");
  }
}


void		menu_create(int	fullscreen)
{
  SDL_Surface	*image;
  char		*file = "menu.bmp";

  menu_init(fullscreen);
  image = SDL_LoadBMP(file);
  if (image == NULL)
    fprintf(stderr, "Impossible de charger %s: %s\n", file, SDL_GetError());
  if (image->format->palette && g_game->graphic->screen->format->palette)
    SDL_SetColors(g_game->graphic->screen, image->format->palette->colors, 0,
		  image->format->palette->ncolors);
  g_game->menu->fond = image;
}

void		menu_display()
{
  SDL_Rect	dest;
  SDL_Event	event;
  int		start = 0;

  dest.x = 0;
  dest.y = 0;
  dest.w = g_game->menu->fond->w;
  dest.h = g_game->menu->fond->h;
  event = g_game->event;
  while (!start)
    {
      SDL_PollEvent(&event);
      switch (event.type)
	{
	  case SDL_MOUSEMOTION :
	    break;
	  case SDL_MOUSEBUTTONDOWN :
	      if ( event.button.button == SDL_BUTTON_LEFT )
		if (((event.motion.x >= 220) && (event.motion.x <= 420))
		    && ((event.motion.y >= 390) && (event.motion.y <= 420)))
		  {
		    start = 1;
		  }
		if (((event.motion.x >= 250) && (event.motion.x <= 380))
		    && ((event.motion.y >= 440) && (event.motion.y <= 465)))
		  {
		    SDL_Quit();
		    exit(0);
		  }
		break;
	  case SDL_KEYDOWN :
	    switch ( event.key.keysym.sym )
	      {
		case SDLK_ESCAPE :
		  SDL_Quit();
		  exit(0);
		  break;
		default :
		  break;
	      }
	    break;
	  case SDL_KEYUP :
	    switch (event.key.keysym.sym)
	      {
		case SDLK_SPACE:
		  start = 1;
		  break;
		default :
		  break;
	      }
	    break;
	  case SDL_QUIT :
	    SDL_Quit();
	    exit(0);
	    break;
	}
      if (SDL_BlitSurface(g_game->menu->fond, NULL, g_game->menu->screen, &dest) != 0)
	printf("ERROR in SDL_BlitSurface\n");
      SDL_UpdateRects(g_game->menu->screen, 1, &dest);

      SDL_Flip(g_game->menu->screen);
    }
}
