/*
** player.c for arkanoid in /u/ispe/le-rou_j/rush/raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 00:55:48 2006 jean-marc le-roux
*/

#include "player.h"
#include "game.h"

s_game	*g_game;

void		player_create(int	num_player)
{
  s_vector3	pos;
  s_vector3s	poss;

  poss.rayon = 45;
  poss.angley = 0;
  poss.anglez = 0;
  pos = sphere2cart(poss);
  if ((g_game->players[num_player] = malloc(sizeof (s_player))))
    {
      g_game->players[num_player]->pos = pos;
      g_game->players[num_player]->poss = poss;
      g_game->players[num_player]->speed = 0.075;
      g_game->players[num_player]->initsize = 4;
      g_game->players[num_player]->size = 4;
      g_game->players[num_player]->transverser = -1;
      g_game->players[num_player]->bspeed = -1;
      g_game->players[num_player]->boost = -1;
      g_game->players[num_player]->invert = -1;
      g_game->players[num_player]->modifsize = -1;
    }
}

void		player_destroy(int	num_player)
{
  num_player = num_player;
}

void		player_update(int	num_player)
{
  s_player	*p;

  p = g_game->players[num_player];
  if (g_game->inputs[0])
  {
    p->poss.angley += p->speed * (SDL_GetTicks() - g_game->to);
  }
  if (g_game->inputs[1])
  {
    p->poss.angley -= p->speed * (SDL_GetTicks() - g_game->to);
  }
  p->pos = sphere2cart(p->poss);
  if (p->modifsize!= -1)
  {
    if (SDL_GetTicks() - p->modifsize > 10000)
    {
      p->modifsize = -1;
      p->size = p->initsize;
    }
  }
}

void		player_display(int	num_player)
{
  float		angle;
  float		rayon;
  float		size;

  angle = g_game->players[num_player]->poss.angley;
  rayon = g_game->players[num_player]->poss.rayon;
  size  = g_game->players[num_player]->size;
  glPushMatrix();
  glRotatef(angle + 90, 0, 1, 0);

  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  glDisable(GL_DEPTH_TEST);

  glBegin(GL_QUADS);
  glColor4f(5.0f, 5.0f, 5.0f, 0.2f);

  glVertex3f(-size, 0.4, rayon);
  glVertex3f(-size, 1.1,  rayon);
  glVertex3f(size,  1.1,  rayon);
  glVertex3f(size,  0.4, rayon);

  glColor4f(1.0f, 1.0f, 1.0f, 0.9f);

  glVertex3f(size, 1.1, rayon + 1);
  glVertex3f(size, 1.1, rayon);
  glVertex3f(-size, 1.1, rayon);
  glVertex3f(-size, 1.1, rayon + 1);

  glColor4f(8.0f, 8.0f, 8.0f, 0.2f);

  glVertex3f(-size, 0.4, rayon + 1);
  glVertex3f(-size, 1.1,  rayon + 1);
  glVertex3f(size,  1.1,  rayon + 1);
  glVertex3f(size,  0.4, rayon + 1);

  glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

  glVertex3f(size, 0.4, rayon + 1);
  glVertex3f(size, 0.4, rayon);
  glVertex3f(-size, 0.4, rayon);
  glVertex3f(-size, 0.4, rayon + 1);

  glEnd();

  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);

  glPopMatrix();
}
