/*
** roller.c for arkanoid in raud_c-arkanoid/src
**
** Made by jean-marc le-roux
** Login   <le-rou_j@epita.fr>
**
** Started on  Sat Nov 18 00:55:48 2006 jean-marc le-roux
** Last update Sun Nov 19 19:25:16 2006 Spycam
*/

#include "roller.h"
#include "game.h"

s_game		*g_game;

void		roller_create(s_vector3s	poss,
			      s_vector3		vit)
{
  s_vector3	pos;
  s_roller	*new;

  pos = sphere2cart(poss);
  new = malloc(sizeof(s_roller));
  new->next = g_game->map->roller;
  g_game->map->roller = new;
  if (new)
  {
    new->pos = pos;
    new->pos.y += 1;
    new->poss = poss;
    new->speed = 0.015;
    new->rayon = 0.4;
    new->vit = vit;
  }
}

void		roller_destroy()
{
  s_roller	*pos;
  s_roller	*next;

  for (pos = g_game->map->roller;
       pos;
       next = pos->next)
  {
    free(pos);
    pos = next;
  }
}

static	float	norm_angle(float		angle)
{
  angle = fmodf(angle, 360);
  if (angle < 0)
    angle += 360;
  return (angle);
}

static int	is_collision(float	planche,
			     float	balle,
			     float	dec)
{
  float		leftvalue;
  float		rightvalue;
  int		result = 1;

  leftvalue = norm_angle(planche - dec);
  rightvalue = norm_angle(planche + dec);
  while (leftvalue > rightvalue)
  {
    leftvalue -= dec + 1;
    rightvalue -= dec + 1;
    balle -= dec + 1;
    leftvalue = norm_angle(leftvalue);
    rightvalue = norm_angle(rightvalue);
    balle = norm_angle(balle);
  }
  /*  printf("Dec: %f Balle: %f LF: %f RF: %f\n", dec, balle, leftvalue, rightvalue);*/
  result = balle >= leftvalue;
  result = result && (balle <= rightvalue);
  return (result);
}

void		roller_update()
{
  s_roller	*pos;
  s_roller	*prev;
  s_roller	*next;
  float		dec;
  float		speed;
  s_vector3	newpos;
  s_vector3s	newposs;
  s_vector3	vitpos;
  s_vector3s	vitposs;

  prev = NULL;
  pos = g_game->map->roller;
  while (pos)
  {
    next = pos->next;
    newpos = pos->pos;
    speed = pos->speed;
    if (g_game->players[0]->bspeed != -1)
    {
      speed += 0.015;
      if (SDL_GetTicks() - g_game->players[0]->bspeed > 10000)
	g_game->players[0]->bspeed = -1;
    }
    newpos.x += pos->vit.x * speed * (SDL_GetTicks() - g_game->to);
    newpos.y += pos->vit.y * speed * (SDL_GetTicks() - g_game->to);
    newpos.z += pos->vit.z * speed * (SDL_GetTicks() - g_game->to);
    newposs = cart2sphere(newpos);
    dec = 1.4 * rad2deg(asin(g_game->players[0]->size / newposs.rayon));
    /*       printf ("x: %f z:%f r:%f\n", newpos.x, newpos.z, newposs.rayon);
	     printf ("%i\n", is_collision(norm_angle(g_game->players[0]->poss.angley), norm_angle(-newposs.angley), dec));*/
    if (((newposs.rayon ) - 2 * pos->rayon<= g_game->players[0]->poss.rayon) &&
	((newposs.rayon + 3 * pos->rayon) >= g_game->players[0]->poss.rayon))
    {
      /*printf("Ok baby\n");
	printf("%f < %f < %f\n", norm_angle(g_game->players[0]->poss.angley - dec), norm_angle(-newposs.angley), norm_angle(g_game->players[0]->poss.angley + dec));*/
      if (is_collision(norm_angle(g_game->players[0]->poss.angley), norm_angle(-newposs.angley), dec))
      {
	/*printf("Collisions !!!!\n");*/
	vitposs = g_game->players[0]->poss;
	vitposs.rayon += g_game->players[0]->size;
	vitpos = sphere2cart(vitposs);
	pos->vit.x = pos->pos.x - vitpos.x;
	pos->vit.z = pos->pos.z - vitpos.z;
	/*	printf("Vect avant vit x:%f , z:%f\n", pos->vit.x, pos->vit.z);*/
	pos->vit = normalize(pos->vit);
	/*	printf("Vect apres vit x:%f , z:%f\n", pos->vit.x, pos->vit.z);*/
      }
      else
      {
	pos->pos = newpos;
	pos->poss = newposs;
      }
    }
    else
    {
      pos->pos = newpos;
      pos->poss = newposs;
    }
    if (pos->pos.y > pos->rayon || pos->poss.rayon > g_game->players[0]->poss.rayon + 2)
      pos->pos.y -= pos->speed * (SDL_GetTicks() - g_game->to);
    if (pos->pos.y < -30)
    {
      if (!prev)
	g_game->map->roller = pos->next;
      else
	prev->next = pos->next;
      free(pos);
    }
    else
      prev = pos;
    pos = next;
  }
  if (!g_game->map->roller) 
  {
    SDL_Quit();
    exit(0);
  }
}

void		roller_display()
{
  s_roller	*pos;

  pos = g_game->map->roller;
  while (pos)
  {
    glPushMatrix();
    glColor3f(1.0f, 1.0f, 1.0f);
    glTranslatef(pos->pos.x, pos->pos.y, pos->pos.z);
    glutSolidSphere(pos->rayon, 10, 10);
    glPopMatrix();
    pos = pos->next;
  }
}
