/*
** toolkit_sphere.c for arkanoid in raud_c-arkanoid/src
**
** Made by Spycam
** Login   <raud_c@epita.fr>
**
** Started on  Sat Nov 18 11:25:59 2006 Spycam
** Last update Mon Nov 20 13:32:12 2006 Spycam
*/

#include "toolkit_sphere.h"

float		fmodf(float		bidule,
		      float		mod)
{
  while (bidule > mod)
    bidule -= mod;
  while (bidule < 0)
    bidule += mod;
  return (bidule);
}

float		fabsf(float		bidule)
{
  return ((bidule < 0) ? -bidule : bidule);
}

float		deg2rad(float		angle)
{
  return (angle / 180 * M_PI);
}

float		rad2deg(float		angle)
{
  return (angle / M_PI * 180);
}

s_vector3	sphere2cart(s_vector3s	pos)
{
  s_vector3	result;

  result.x = cos(-deg2rad(pos.angley)) * pos.rayon;
  result.y = 0;
  result.z = sin(-deg2rad(pos.angley)) * pos.rayon;
  return (result);
}
s_vector3s      cart2sphere(s_vector3	pos)
{
  s_vector3s	result;

  result.rayon = sqrt(pow(pos.x, 2) + pow(pos.z, 2));
  if (pos.x == 0)
    result.angley = 90;
  else
    result.angley = rad2deg(atan(pos.z / pos.x));
  if (pos.x < 0)
    result.angley += 180;
  result.anglez = 0;
  return (result);
}

s_vector3	normalize(s_vector3	vect)
{
  float		max;

  if (fabsf(vect.x) > fabsf(vect.z))
    max = fabsf(vect.x);
  else
    max = fabsf(vect.z);
  vect.x /= max;
  vect.z /= max;
  return (vect);
}
